#ifndef INT_STACK_H
#define INT_STACK_H

struct Item {
    int data;
    Item* previous;
};

// Δημιουργεί μια άδεια στοίβα (ουσιαστικά nullptr)
Item* stackCreate();

// Επιστρέφει true αν η στοίβα είναι άδεια
bool stackEmpty(Item* stack);

// Προσθέτει ένα στοιχείο στην κορυφή της στοίβας
void stackPush(Item*& stack, int value);

// Αφαιρεί το στοιχείο από την κορυφή και επιστρέφει την τιμή του
// Αν η στοίβα είναι άδεια, εμφανίζει μήνυμα και επιστρέφει 0
int stackPop(Item*& stack);

#endif // INT_STACK_H

