#include "IntArray.h"
#include <iostream>
using namespace std;

IntArray createIntArray(int size, int value) {
    IntArray arr;
    arr.size = size;

    if (size <= 0) {
        arr.t = nullptr;
        arr.size = 0;
        return arr;
    }

    arr.t = new int[size];
    for (int i = 0; i < size; ++i) {
        arr.t[i] = value;
    }

    return arr;
}

void printIntArray(const IntArray& arr) {
    cout << "[";
    for (int i = 0; i < arr.size; ++i) {
        cout << arr.t[i];
        if (i < arr.size - 1)
            cout << ", ";
    }
    cout << "]" << endl;
}

void resizeIntArray(IntArray& arr, int newSize) {
    if (newSize <= 0) {
        // αν το νέο μέγεθος δεν είναι θετικό, καταστρέφουμε τον πίνακα
        destroyIntArray(arr);
        return;
    }

    // Δέσμευση νέου πίνακα
    int* newData = new int[newSize];

    int limit = (arr.size < newSize) ? arr.size : newSize;

    // Αντιγραφή των υπαρχόντων στοιχείων
    for (int i = 0; i < limit; ++i) {
        newData[i] = arr.t[i];
    }

    // Αρχικοποίηση των υπόλοιπων στοιχείων (αν ο νέος πίνακας είναι μεγαλύτερος)
    for (int i = limit; i < newSize; ++i) {
        newData[i] = 0;
    }

    // Αποδέσμευση παλιού πίνακα
    delete [] arr.t;

    // Ενημέρωση της δομής
    arr.t = newData;
    arr.size = newSize;
}

void destroyIntArray(IntArray& arr) {
    if (arr.t != nullptr) {
        delete [] arr.t;
        arr.t = nullptr;
    }
    arr.size = 0;
}

